VERSION 5.00
Begin VB.UserControl armItemSel 
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   13050
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15540
   ScaleHeight     =   13050
   ScaleWidth      =   15540
   Begin VB.Frame fraRef 
      Caption         =   "#Item Reference"
      Height          =   2295
      Left            =   4920
      TabIndex        =   6
      Tag             =   "fraRef"
      Top             =   840
      Width           =   5295
      Begin VB.TextBox txtRef 
         Height          =   375
         Left            =   2040
         TabIndex        =   23
         Tag             =   "txtRef"
         Top             =   1800
         Width           =   3135
      End
      Begin VB.Frame fraRefLevel 
         Caption         =   "#Search on"
         Height          =   615
         Left            =   120
         TabIndex        =   25
         Tag             =   "fraRefSrcCode"
         Top             =   240
         Width           =   5055
         Begin VB.OptionButton optRefLevel 
            Caption         =   "SAP code level"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   17
            Tag             =   "optRefLevelSAP"
            Top             =   240
            Width           =   2295
         End
         Begin VB.OptionButton optRefLevel 
            Caption         =   "Marketing code level"
            Height          =   255
            Index           =   1
            Left            =   2640
            TabIndex        =   18
            Tag             =   "optRefLevelMkt"
            Top             =   240
            Width           =   2295
         End
      End
      Begin VB.Frame fraRefPattern 
         Height          =   855
         Left            =   120
         TabIndex        =   24
         Tag             =   "fraRefPattern"
         Top             =   840
         Width           =   5055
         Begin VB.OptionButton OptRefPattern 
            Caption         =   "#Equal to"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   19
            Tag             =   "OptRefPatternEqual"
            Top             =   240
            Width           =   1335
         End
         Begin VB.OptionButton OptRefPattern 
            Caption         =   "#Begin by"
            Height          =   255
            Index           =   1
            Left            =   2640
            TabIndex        =   20
            Tag             =   "OptRefPatternBeg"
            Top             =   240
            Width           =   1335
         End
         Begin VB.OptionButton OptRefPattern 
            Caption         =   "#Contains"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   21
            Tag             =   "OptRefPatternCont"
            Top             =   480
            Width           =   1335
         End
         Begin VB.OptionButton OptRefPattern 
            Caption         =   "#End by"
            Height          =   255
            Index           =   3
            Left            =   2640
            TabIndex        =   22
            Tag             =   "OptRefPatternEnd"
            Top             =   480
            Width           =   1335
         End
      End
      Begin VB.Label lblRef 
         Caption         =   "#Reference"
         Height          =   255
         Left            =   120
         TabIndex        =   26
         Tag             =   "lblRef"
         Top             =   1920
         Width           =   1695
      End
   End
   Begin VB.Frame fraResult 
      Height          =   5535
      Left            =   4920
      TabIndex        =   31
      Tag             =   "fraResult"
      Top             =   3240
      Width           =   5295
      Begin Project1.ArmGrid grSelection 
         Height          =   2655
         Left            =   120
         TabIndex        =   33
         Top             =   2760
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   4683
      End
      Begin Project1.ArmGrid grResult 
         Height          =   2295
         Left            =   120
         TabIndex        =   32
         Top             =   240
         Width           =   5055
         _ExtentX        =   8916
         _ExtentY        =   4048
      End
   End
   Begin VB.Frame fraTV 
      Height          =   5535
      Left            =   120
      TabIndex        =   29
      Top             =   3240
      Width           =   4695
      Begin Project1.ArmTreeView tvSel 
         Height          =   4815
         Left            =   120
         TabIndex        =   16
         Top             =   600
         Width           =   4455
         _ExtentX        =   7858
         _ExtentY        =   8493
      End
      Begin Project1.ArmCombobox cboViews 
         Height          =   345
         Left            =   1200
         TabIndex        =   15
         Top             =   240
         Width           =   3375
         _ExtentX        =   5953
         _ExtentY        =   609
      End
      Begin VB.Label lblViews 
         Caption         =   "#Views"
         Height          =   255
         Left            =   120
         TabIndex        =   30
         Tag             =   "lblViews"
         Top             =   360
         Width           =   735
      End
   End
   Begin Project1.ToolbarControl tcSearch 
      Height          =   690
      Left            =   120
      TabIndex        =   27
      Top             =   120
      Width           =   10095
      _ExtentX        =   17806
      _ExtentY        =   1217
   End
   Begin VB.Frame fraFilters 
      Height          =   2295
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   4695
      Begin VB.Frame fraPlants 
         Caption         =   "#Plants"
         Height          =   495
         Left            =   120
         TabIndex        =   34
         Tag             =   "fraPlants"
         Top             =   1200
         Width           =   4455
         Begin VB.OptionButton optPlants 
            Caption         =   "#Suppliers"
            Height          =   255
            Index           =   2
            Left            =   2880
            TabIndex        =   12
            Tag             =   "optPlantsSuppliers"
            Top             =   200
            Width           =   1455
         End
         Begin VB.OptionButton optPlants 
            Caption         =   "#Plants"
            Height          =   255
            Index           =   1
            Left            =   1320
            TabIndex        =   11
            Tag             =   "optPlantsPlants"
            Top             =   200
            Width           =   1335
         End
         Begin VB.OptionButton optPlants 
            Caption         =   "#All"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   10
            Tag             =   "optPlantsAll"
            Top             =   200
            Width           =   1215
         End
      End
      Begin VB.Frame fraSearch 
         Height          =   495
         Left            =   120
         TabIndex        =   28
         Tag             =   "fraSearch"
         Top             =   1680
         Width           =   4455
         Begin VB.OptionButton OptSearch 
            Caption         =   "#Select"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   13
            Tag             =   "OptSearchSel"
            Top             =   120
            Width           =   2055
         End
         Begin VB.OptionButton OptSearch 
            Caption         =   "#Direct input"
            Height          =   255
            Index           =   1
            Left            =   2280
            TabIndex        =   14
            Tag             =   "OptSearchDir"
            Top             =   120
            Width           =   2055
         End
      End
      Begin VB.Frame fraItemValidity 
         Caption         =   "#Item validity"
         Height          =   1095
         Left            =   2400
         TabIndex        =   5
         Tag             =   "fraItemValidity"
         Top             =   120
         Width           =   2175
         Begin VB.OptionButton optItemValidity 
            Caption         =   "#Non dropped"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   9
            Tag             =   "optItemValNonDrop"
            Top             =   720
            Width           =   1815
         End
         Begin VB.OptionButton optItemValidity 
            Caption         =   "#Dropped"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   8
            Tag             =   "optItemValDrop"
            Top             =   480
            Width           =   1815
         End
         Begin VB.OptionButton optItemValidity 
            Caption         =   "#All"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   7
            Tag             =   "optItemValidity"
            Top             =   240
            Width           =   1815
         End
      End
      Begin VB.Frame fraItemType 
         Caption         =   "#Item type"
         Height          =   1095
         Left            =   120
         TabIndex        =   4
         Tag             =   "fraItemType"
         Top             =   120
         Width           =   2175
         Begin VB.OptionButton optItemType 
            Caption         =   "#Special"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   3
            Tag             =   "optItemTypeSpec"
            Top             =   720
            Width           =   1815
         End
         Begin VB.OptionButton optItemType 
            Caption         =   "#Standard"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   2
            Tag             =   "optItemTypeStd"
            Top             =   480
            Width           =   1815
         End
         Begin VB.OptionButton optItemType 
            Caption         =   "#All"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   1
            Tag             =   "optItemTypeAll"
            Top             =   240
            Width           =   1815
         End
      End
   End
End
Attribute VB_Name = "armItemSel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const C_SCREENNAME As String = "ItemSel"

Private Const C_TB_SEARCH_VALIDATE As String = "H"
Private Const C_TB_SEARCH_RESET As String = "I"
Private Const C_TB_SEARCH_REFRESHTV As String = "F"
Private Const C_TB_SEARCH_REFRESHIN As String = "G"

Private Const C_TB_SEARCH_SELECT As String = "Y"
Private Const C_TB_SEARCH_UNSELECT As String = "Z"
Private Const C_TB_SEARCH_EXIT As String = "T"

Private Const C_TB_SEARCH_SEARCHTV As String = "M"
Private Const C_TB_SEARCH_LOADTV As String = "L"

Private Const C_TB_SEARCH_SEARCHDIR As String = "A"

Private Const C_TB_SEARCH_CLEAR As String = "C"


Private Const C_TB_FACE_SEARCHTV As String = "0"
Private Const C_TB_FACE_SEARCHDIR As String = "1"

Private Const C_DEFAULT_ITEMTYPE As Long = 1
Private Const C_DEFAULT_ITEMVALIDITY As Long = 2
Private Const C_DEFAULT_ITEMLEVEL As Long = 0
Private Const C_DEFAULT_SEARCH As Long = 0
Private Const C_DEFAULT_PATTERN As Long = 1
Private Const C_DEFAULT_PLANTS As Long = 0

Private Const C_STATIC_COLOR As Long = &H80000018

Private mInitialized As Boolean

#If LIVE Then
Private mDb As Object
#Else
Private mDb As ArmDb
#End If

Private Enum eSearchType
    estBySelect = 0
    estByDirectInput = 1
End Enum
Private mSearchType As eSearchType

Private Enum eSearchLike
    eslEqual = 0
    eslBegin = 1
    eslContains = 2
    eslEnd = 3
End Enum

Private Enum ePlantsType
    eptAll = 0
    eptPlants = 1
    eptSuppliers = 2
End Enum

Private Enum eItemLevel
    eilSAP = 0
    eilShort = 1
End Enum

Private Type TTreeViewInfo
    Levels As Long
    NodeRequest() As String
    GridRequest() As String
    ExcelRequest() As String
    CountRequest() As String
    FindRequest() As String
    Images() As Integer
    SelectedImages() As Integer
    TreeViewCode As String
    Loaded As Boolean
End Type
Private mTreeViewInfos() As TTreeViewInfo

Private mLanguage_Code As String

Private mInhibUpdate As Boolean
Private mFullResult As Variant

Public Event quit()

'BI_SAP_Code, Short_Code, Plant
Public Event SelectItems(ByRef aItems() As String, ByRef aRows() As Boolean)

Public Function Load_A_COM() As Boolean

    Const CL_REQUEST_TB As String = "SELECT Info FROM Toolbars_Definitions WHERE ID=$id$"

    fraFilters.Visible = True
    fraResult.Visible = False
    fraTV.Visible = False
    fraRef.Visible = False

    Call LoadLabels(mDb, Controls, C_SCREENNAME, mLanguage_Code)


    Dim lCursTB As Long
    tcSearch.Load_A_COM
    tcSearch.Language = "E"
    lCursTB = mDb.OpenSQL(Replace(CL_REQUEST_TB, "$id$", 56))
    Call tcSearch.SetToolbarInfoStringParameters(mDb.GetFields(lCursTB, "info"), "007")
    Call tcSearch.DisplayFace(0)
    mDb.Close (lCursTB)


    Dim lData As Long, lLabels As Variant
    lData = mDb.OpenSQL("SELECT Field_Name, Local_Text FROM Screen_Constants WHERE Screen_Name = '" & C_SCREENNAME & "' AND Field_Name LIKE 'gr%'")
    
    Dim lColumns() As String
    ' Initialize the grid
    Set grResult.ArmDb = mDb
    grResult.AllowExcelExport = True
    grResult.ExportTitles = True
    grResult.Load_A_COM
    
    grResult.ResetGrid
    grResult.MultiSelect = True
    
'P begin update TM 04/2009
    grResult.FetchAll = True
'P end
    Dim lIdx As Long
    lIdx = mDb.Find(lData, "Field_Name", "grList")
    lLabels = Split(mDb.GetFieldsAt(lData, lIdx, "Local_Text"), CH_LDELIMIT)
    If UBound(lLabels) < 14 Then
        lLabels = Array("#MFGP_Code", "#SAP Code", "#Short Code", "#Plant/Supplier", "#Surface", "#Module", "#Thickness", "#Segmentation", "#Edge detail", "#Colour", "#Family", "#Shape", "#Category", "#Base material", "#Pattern")
    End If
    
    ' 15
    ReDim lColumns(15)
    lColumns(0) = "MFGP_Code" & CH_LDELIMIT & "0" & CH_LDELIMIT & "1" & CH_LDELIMIT & "MFGP_Code" & CH_LDELIMIT & lLabels(0)
    lColumns(1) = "BI_SAP_CODE" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "2" & CH_LDELIMIT & "BI_SAP_CODE" & CH_LDELIMIT & lLabels(1)
    lColumns(2) = "BI_Short_Code" & CH_LDELIMIT & "1200" & CH_LDELIMIT & "3" & CH_LDELIMIT & "BI_Short_Code" & CH_LDELIMIT & lLabels(2)
    lColumns(3) = "MFGP_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "MFGP_Desc" & CH_LDELIMIT & lLabels(3)
    lColumns(4) = "SF_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SF_Desc" & CH_LDELIMIT & lLabels(4)
    lColumns(5) = "PM_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PM_Desc" & CH_LDELIMIT & lLabels(5)
    lColumns(6) = "BI_Thickness" & CH_LDELIMIT & "500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "BI_Thickness" & CH_LDELIMIT & lLabels(6)
    lColumns(7) = "PS_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PS_Desc" & CH_LDELIMIT & lLabels(7)
    lColumns(8) = "PE_Desc" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PE_Desc" & CH_LDELIMIT & lLabels(8)
    lColumns(9) = "COLOUR_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "COLOUR_Desc" & CH_LDELIMIT & lLabels(9)
    lColumns(10) = "PF_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PF_Desc" & CH_LDELIMIT & lLabels(10)
    lColumns(11) = "SH_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "SH_Desc" & CH_LDELIMIT & lLabels(11)
    lColumns(12) = "CG_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "CG_Desc" & CH_LDELIMIT & lLabels(12)
    lColumns(13) = "BML_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "BML_Desc" & CH_LDELIMIT & lLabels(13)
    lColumns(14) = "PP_Desc" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "PP_Desc" & CH_LDELIMIT & lLabels(14)
    lColumns(15) = "STATIC" & CH_LDELIMIT & "0" & CH_LDELIMIT & "0" & CH_LDELIMIT & "STATIC" & CH_LDELIMIT & "STATIC"
        
    grResult.SetColumns lColumns

    Set grSelection.ArmDb = mDb
    grSelection.AllowExcelExport = True
    grSelection.ExportTitles = True
    grSelection.Load_A_COM
    
    grSelection.ResetGrid
    grSelection.MultiSelect = True
    grSelection.SetColumns lColumns
    
    Set tvSel.ArmDb = mDb
    tvSel.Language = mLanguage_Code
    tvSel.AllowCheckboxes = True
    tvSel.UseImages = False
    Call tvSel.Load_A_COM
    
    Set cboViews.ArmDb = mDb
    cboViews.Load_A_COM
    Call cboViews.Clear
    cboViews.FirstBlankItem = False
    cboViews.Request = "exec TreeView_View_t_lst '" & C_SCREENNAME & "'," & "'" & mLanguage_Code & "'"
    cboViews.Load
    If cboViews.Count = 0 Then
        ' ERROR FATAL
        Exit Function
    End If
    cboViews.DroppedWith = cboViews.Width * 2
    
   Dim lCount As Long
    lCount = cboViews.Count - 1
    ReDim mTreeViewInfos(lCount)
    For lIdx = 0 To lCount
        mTreeViewInfos(lIdx).Loaded = False
        mTreeViewInfos(lIdx).TreeViewCode = cboViews.ComboItems(lIdx + 1).Key
    Next
    
    Call Reinit

    mInitialized = True
    
    Load_A_COM = mInitialized
    
End Function


Public Function Unload_A_COM() As Boolean
'
    mInitialized = False
    Unload_A_COM = True

End Function


Public Property Get Initialized() As Boolean
    Initialized = mInitialized
End Property


#If LIVE Then
Public Property Set Db(ByRef aDb As Object)
#Else
Public Property Set Db(ByRef aDb As ArmDb)
#End If
    Set mDb = aDb
End Property

Public Property Let Language_Code(ByVal aLanguage_Code As String)
    mLanguage_Code = aLanguage_Code
End Property

Private Sub optItemType_Click(Index As Integer)
    Call ClearResult
End Sub

Private Sub optItemValidity_Click(Index As Integer)
    Call ClearResult
End Sub

Private Sub optPlants_Click(Index As Integer)
    Call ClearResult
End Sub

Private Sub optRefLevel_Click(Index As Integer)
    Call ClearResult
End Sub

Private Sub OptRefPattern_Click(Index As Integer)
    Call ClearResult
End Sub

Private Sub tcSearch_action(ByVal as_Role As String, as_Language As String)

    Dim lMouse As Long
    lMouse = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    
    Select Case as_Role
        Case C_TB_SEARCH_VALIDATE
            Call SendSelection
            
        Case C_TB_SEARCH_RESET
            Call Reinit(True)
            
        Case C_TB_SEARCH_CLEAR
            Call ClearSelection
            
        Case C_TB_SEARCH_SEARCHTV
            Call LoadCurrentTVSelection
            
        Case C_TB_SEARCH_LOADTV
            Call LoadTreeView(GetTreeViewInfo(cboViews.SelectedItem.Key))
            
        Case C_TB_SEARCH_SEARCHDIR
            Call SearchDirectInput
        
        Case C_TB_SEARCH_REFRESHIN
            Call SearchDirectInput
        
        Case C_TB_SEARCH_REFRESHTV
            Call RefreshList
            
        Case C_TB_SEARCH_SELECT
            Call SelectItem
            
        Case C_TB_SEARCH_UNSELECT
            Call UnselectItem
        
        Case C_TB_SEARCH_EXIT
            Call ClearSelection
            RaiseEvent quit
            
    End Select

    Screen.MousePointer = lMouse

End Sub


Public Sub Reinit(Optional ByVal aKeepSel As Boolean = False)

    Dim lMouse As Long
    lMouse = Screen.MousePointer
    Screen.MousePointer = vbHourglass

    mInhibUpdate = True
    
    grResult.ClearGrid
    
    
    If aKeepSel Then
        Dim lIdx As Long, lCount As Long
        lCount = grSelection.Rows - 1
        grSelection.Visible = False
        For lIdx = 0 To lCount
            If grSelection.Data(lIdx, 15) <> 1 Then
                grSelection.Row = lIdx
                grSelection.DeleteLine
            End If
        Next
        grSelection.Visible = True
    Else
       grSelection.ClearGrid
    End If

    optItemType(C_DEFAULT_ITEMTYPE).value = True
    optItemValidity(C_DEFAULT_ITEMVALIDITY).value = True
    optRefLevel(C_DEFAULT_ITEMLEVEL).value = True
    OptRefPattern(C_DEFAULT_PATTERN).value = True
    optPlants(C_DEFAULT_PLANTS).value = True
    OptSearch(C_DEFAULT_SEARCH).value = True
    txtRef.Text = ""
    mInhibUpdate = False
    
    Call EnableSearch(C_DEFAULT_SEARCH)
    cboViews.SearchItem "X", "TV_Default", 0
    Screen.MousePointer = lMouse
    
End Sub


Private Sub OptSearch_Click(Index As Integer)
    Dim lMouse As Long
    lMouse = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    
    Call EnableSearch(Index)
    
    Screen.MousePointer = lMouse
End Sub


Private Sub EnableSearch(ByVal aSearchType As eSearchType)

    fraTV.Visible = False
    fraRef.Visible = False
    fraResult.Visible = False
    tcSearch.Visible = False
    
    grResult.ClearGrid

    Dim lTBFace As String
    Select Case aSearchType
        Case eSearchType.estByDirectInput
            Call EnableSearch_ByInput
            
        Case eSearchType.estBySelect
            Call EnableSearch_BySelect

    End Select
    
    fraResult.Visible = True
    tcSearch.Visible = True
    mSearchType = aSearchType

    If aSearchType = eSearchType.estByDirectInput Then
        txtRef.SetFocus
    End If
    

End Sub


Private Sub EnableSearch_ByInput()
    
    fraResult.Top = fraFilters.Top + fraFilters.Height + 120
    fraResult.Left = fraTV.Left
    fraResult.Height = UserControl.Height - fraResult.Top - 120
    fraResult.Width = UserControl.Width - fraResult.Left - 120

    Dim lMiddle As Long
    lMiddle = (fraResult.Height / 2)
    grResult.Width = fraResult.Width - grResult.Left - 120
    grResult.Height = lMiddle - grResult.Top - 60
    
    grSelection.Width = grResult.Width
    grSelection.Top = lMiddle + 60
    grSelection.Height = fraResult.Height - grSelection.Top - 120
    
    tcSearch.DisplayFace (C_TB_FACE_SEARCHDIR)
    fraRef.Visible = True
End Sub


Private Sub EnableSearch_BySelect()

    fraTV.Height = UserControl.Height - fraTV.Top - 120
    tvSel.Height = fraTV.Height - tvSel.Top - 120
    fraResult.Top = fraFilters.Top
    fraResult.Left = fraFilters.Left + fraFilters.Width + 120
    fraResult.Height = UserControl.Height - fraResult.Top - 120
    fraResult.Width = UserControl.Width - fraResult.Left - 120
    
    Dim lMiddle As Long
    lMiddle = (fraResult.Height / 2)
    grResult.Width = fraResult.Width - grResult.Left - 120
    grResult.Height = lMiddle - grResult.Top - 60
    
    grSelection.Width = grResult.Width
    grSelection.Top = lMiddle + 60
    grSelection.Height = fraResult.Height - grSelection.Top - 120
    
    tcSearch.DisplayFace (C_TB_FACE_SEARCHTV)
    tcSearch.ButtonVisible(C_TB_SEARCH_LOADTV) = False
    fraTV.Visible = True
    
End Sub


Private Sub ClearResult()
    
    Dim lMousePointer As Long
    lMousePointer = Screen.MousePointer
    grResult.ClearGrid
    
    If mSearchType = estBySelect Then
        tvSel.Clear
        tcSearch.Visible = False
        If tcSearch.ButtonVisible(C_TB_SEARCH_SEARCHTV) Then tcSearch.ButtonVisible(C_TB_SEARCH_SEARCHTV) = False
        If Not tcSearch.ButtonVisible(C_TB_SEARCH_LOADTV) Then tcSearch.ButtonVisible(C_TB_SEARCH_LOADTV) = True
        tcSearch.Visible = True
    End If
    
    Screen.MousePointer = lMousePointer
    
End Sub


Private Sub txtRef_Change()
    Call ClearResult
End Sub



Private Sub SearchDirectInput()

    Const C_REQUEST = "EXEC ItemSel_List '$lang$', $type$, $drop$, $pltype$, $SAPLike$, $SHORTLike$, null, null, null, null, null, null, null, null, null"
    
    If txtRef.Text = "" Then Exit Sub
    
    Dim lPattern As String
    If txtRef.Text <> "" Then
        lPattern = Replace(txtRef.Text, "'", "''", , , vbTextCompare)
        If OptRefPattern(eSearchLike.eslBegin).value Or OptRefPattern(eSearchLike.eslContains) Then
            lPattern = lPattern & "%"
        End If
        If OptRefPattern(eSearchLike.eslEnd).value Or OptRefPattern(eSearchLike.eslContains) Then
            lPattern = "%" & lPattern
        End If
        lPattern = "'" & lPattern & "'"
    Else
        lPattern = Null
    End If
        
    Dim lRequest As String
    lRequest = ReplaceHolders(C_REQUEST)
    lRequest = Replace(lRequest, "$SAPLike$", IIf(optRefLevel(eItemLevel.eilSAP).value, lPattern, "null"), , , vbTextCompare)
    lRequest = Replace(lRequest, "$ShortLike$", IIf(optRefLevel(eItemLevel.eilShort).value, lPattern, "null"), , , vbTextCompare)
    
    grResult.Requests = lRequest
    'If Not grResult.Execute Then
    If Not LoadResultGrid Then
        ' TODO : error
    End If

End Sub


Private Function GetOptSelected(ByVal aOptions As Variant) As Long
    Dim lIdx As Long, lCount As Long
    lCount = aOptions.Count - 1
    For lIdx = 0 To lCount
        If aOptions(lIdx).value Then
            GetOptSelected = lIdx
            Exit Function
        End If
    Next
    GetOptSelected = -1
End Function


Private Function ReplaceHolders(ByVal aRequest As String) As String
    Dim lRequest As String
    lRequest = aRequest
    lRequest = Replace(lRequest, "$lang$", mLanguage_Code, , , vbTextCompare)
    lRequest = Replace(lRequest, "$type$", Choose(GetOptSelected(optItemType) + 1, "null", "'STD'", "'SPC'"), , , vbTextCompare)
    lRequest = Replace(lRequest, "$drop$", Choose(GetOptSelected(optItemValidity) + 1, "null", "'Y'", "'N'"), , , vbTextCompare)
    lRequest = Replace(lRequest, "$pltype$", Choose(GetOptSelected(optPlants) + 1, "null", "P", "S"), , , vbTextCompare)
    ReplaceHolders = lRequest
End Function



Private Function GetTreeViewInfoFromDB(ByVal aTVCode As String) As TTreeViewInfo

    Dim lTreeView As TTreeViewInfo
    Dim lRequest As String
    Dim lCurs As Long, lIdx As Long, lCount As Long
    
    ' Get the data from the DB
    lRequest = "EXEC Treeview_Parameters_lst '" & C_SCREENNAME & "', '" & aTVCode & "'"
    lCurs = mDb.OpenSQL(lRequest)
    
    lCount = mDb.RowCount(lCurs) - 1
    
    ReDim lTreeView.NodeRequest(lCount)
    ReDim lTreeView.GridRequest(lCount)
    ReDim lTreeView.ExcelRequest(lCount)
    ReDim lTreeView.FindRequest(lCount)
    ReDim lTreeView.CountRequest(lCount)
    ReDim lTreeView.Images(lCount)
    ReDim lTreeView.SelectedImages(lCount)
    
    Dim lLevel As Long
    For lIdx = 0 To lCount
        lLevel = mDb.GetFields(lCurs, "TV_Level")
        lTreeView.NodeRequest(lLevel) = mDb.GetFields(lCurs, "TV_NodeRequest")
        lTreeView.GridRequest(lLevel) = mDb.GetFields(lCurs, "TV_GridRequest")
        lTreeView.ExcelRequest(lLevel) = mDb.GetFields(lCurs, "TV_ExcelRequest")
        lTreeView.FindRequest(lLevel) = mDb.GetFields(lCurs, "TV_FindRequest")
        lTreeView.CountRequest(lLevel) = mDb.GetFields(lCurs, "TV_CountRequest")
        lTreeView.Images(lLevel) = mDb.GetFields(lCurs, "TV_Images")
        lTreeView.SelectedImages(lLevel) = mDb.GetFields(lCurs, "TV_SelectedImages")
        mDb.Next (lCurs)
    Next
    
    lTreeView.TreeViewCode = aTVCode
    lTreeView.Levels = lCount + 1
    lTreeView.Loaded = True
    GetTreeViewInfoFromDB = lTreeView
    
    mDb.Close (lCurs)
    
End Function


Private Function GetTreeViewInfo(ByVal aTVCode As String) As TTreeViewInfo
    
    Dim lIdx As Long, lCount As Long
    Dim lTreeView As TTreeViewInfo, lFound As Boolean
    
    ' Search in the array
    lCount = UBound(mTreeViewInfos)
    lFound = False
    For lIdx = 0 To lCount
        If mTreeViewInfos(lIdx).TreeViewCode = aTVCode Then
            mTreeViewInfos(lIdx).Loaded = False
            If Not mTreeViewInfos(lIdx).Loaded Then
                mTreeViewInfos(lIdx) = GetTreeViewInfoFromDB(aTVCode)
            End If
            lTreeView = mTreeViewInfos(lIdx)
            lFound = True
            Exit For
        End If
    Next
    
    If Not lFound Then
        'ERROR
    End If
    
    GetTreeViewInfo = lTreeView
    
End Function

Private Function LoadTreeView(ByRef aTreeViewInfo As TTreeViewInfo) As Boolean
    
    tvSel.Visible = False

    tvSel.Clear
    ' Clearing the associated grid
    grResult.Requests = ""
    Call grResult.ClearGrid

    tvSel.Levels = aTreeViewInfo.Levels
    tvSel.StartDemandLevel = 1
    tvSel.SelectedImages = aTreeViewInfo.SelectedImages
    tvSel.Images = aTreeViewInfo.Images
    tvSel.NodeRequests = ReplaceHoldersLst(aTreeViewInfo.NodeRequest)
    tvSel.GridRequests = ReplaceHoldersLst(aTreeViewInfo.GridRequest)
    tvSel.FindRequests = ReplaceHoldersLst(aTreeViewInfo.FindRequest)
    tvSel.CountRequests = ReplaceHoldersLst(aTreeViewInfo.CountRequest)
    
    If Not tvSel.LoadTree(LoadTypeChildsDemand) Then
        'ERROR
        'debug.print "Error"
    End If
    
    tvSel.Visible = True
    tcSearch.Visible = False
    tcSearch.ButtonVisible(C_TB_SEARCH_SEARCHTV) = True
    tcSearch.ButtonVisible(C_TB_SEARCH_LOADTV) = False
    tcSearch.Visible = True
    mFullResult = 0
    LoadTreeView = True
    
End Function

Private Sub cboViews_ComboItemSelected()
    If Not cboViews.SelectedItem Is Nothing Then
        Call LoadTreeView(GetTreeViewInfo(cboViews.SelectedItem.Key))
    End If
End Sub


Private Function ReplaceHoldersLst(ByRef aRequests() As String) As String()

    Dim lRequests() As String
    ReDim lRequests(UBound(aRequests))
    Dim lIdx As Long, lCount As Long
    lCount = UBound(aRequests)
    For lIdx = 0 To lCount
        lRequests(lIdx) = ReplaceHolders(aRequests(lIdx))
    Next
    ReplaceHoldersLst = lRequests
    
End Function



Private Sub tvSel_NodeClick(ByVal Node As MSComctlLib.Node)
    
    Screen.MousePointer = vbHourglass
    mFullResult = 0

    If tvSel.Checkboxes Then
        grResult.Requests = ""
        Call grResult.ClearGrid
    
        Screen.MousePointer = 0
    ' Nothing to do
        Exit Sub
    End If

    ' Clear the grids
    grResult.Requests = ""
    Call grResult.ClearGrid

    ' If the selected node is on the last level, we have to load the grids
    If tvSel.NodeInfo(Node).ml_Level = tvSel.Levels - 1 Then
        grResult.Requests = tvSel.SelectedNodeRequest
        'If grResult.Execute = False Then
        If Not LoadResultGrid Then
            'ERROR
            'debug.print "Error in tvSel_NodeClick"
        End If
    End If

    Screen.MousePointer = 0

End Sub

Private Sub tvSel_CheckboxesChange(Checkboxes As Boolean)
    grResult.Requests = ""
    Call grResult.ClearGrid
End Sub


Private Sub LoadCurrentTVSelection()
    
    If tvSel.SelectedItem Is Nothing And Not tvSel.Checkboxes Then Exit Sub
    
    If tvSel.Checkboxes = True Then
        grResult.Requests = tvSel.CheckedNodesRequests
    Else
        grResult.Requests = tvSel.SelectedNodeRequest
    End If
    If Not LoadResultGrid Then
        'Error
        'debug.print "Error in loadcurrenttvselection"
    End If
End Sub



Private Sub RefreshList()

    tvSel.Refresh
    If tvSel.Checkboxes = True Or grResult.Row > 0 Then
        Call LoadCurrentTVSelection
    End If
End Sub


Private Sub grResult_ItemSelected()
    Call SelectItem
End Sub


Private Sub grSelection_ItemSelected()
    Call UnselectItem
End Sub


Private Sub SelectItem()
    
    If grResult.SelectedCount = 0 Then Exit Sub
    
    Dim lScreenPointer As Long
    lScreenPointer = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    
'    If Not IsArray(grResult.MultiSelectedKey) Then Exit Sub
    
    Dim lIdx As Long, lCount As Long, lKeys As Variant
    Dim lIdxCol As Long, lCountCol As Long, lLine As Variant
    grSelection.Visible = False
    
    ReDim lLine(grResult.Cols - 1)
    
    lCount = UBound(grResult.MultiSelectedKey)
    Dim lSelectedKey As Variant, lSelectedLines As Variant
    lSelectedKey = grResult.MultiSelectedKey
    For lIdx = 0 To lCount
        lKeys = lSelectedKey(lIdx)
        If Not grSelection.SearchKey(True, lKeys) Then
            lCountCol = grResult.Cols - 1
            For lIdxCol = 0 To lCountCol
                lLine(lIdxCol) = grResult.SelectedLine(lIdx, lIdxCol)
            Next
            grSelection.AddLine (lLine)
            'grResult.DeleteLine (lKeys)
        End If
    Next
   
    Call grResult.DeselectRow
    For lIdx = 0 To lCount
        If grSelection.SearchKey(True, lKeys) Then grResult.DeleteLine (lSelectedKey(lIdx))
    Next
    
    
    grSelection.Visible = True
    Screen.MousePointer = lScreenPointer

End Sub


Private Sub UnselectItem()
    
    If grSelection.SelectedCount = 0 Then Exit Sub
    
    Dim lScreenPointer As Long
    lScreenPointer = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    
    Dim lStaticSelect As Boolean
    
    ReDim lLine(grResult.Cols - 1)
    
    Dim lIdx As Long, lCount As Long, lKeys As Variant
    Dim lIdxCol As Long, lCountCol As Long, lLines As Variant
    grSelection.Visible = False
    lCount = UBound(grSelection.MultiSelectedKey)
    lKeys = grSelection.MultiSelectedKey
    grResult.Visible = False
    For lIdx = 0 To lCount
        
        ' Check if the line is read - only
        If grSelection.SelectedLine(lIdx, "STATIC") = 1 Then
            lStaticSelect = True
            GoTo NextOne:
        End If
        
        ' if the line is founded into the full result array, need to be added to the result grid
        If FindInFullResult(lKeys(lIdx)) Then
            lCountCol = grResult.Cols - 1
            For lIdxCol = 0 To lCountCol
                lLine(lIdxCol) = grSelection.SelectedLine(lIdx, lIdxCol)
            Next
            grResult.AddLine (lLine)
        End If
        'grSelection.DeleteLine (lKeys(lIdx))
NextOne:
    Next
    grResult.Visible = True
    
    For lIdx = 0 To lCount
        ' Check if the line is read - only
        Call grSelection.SearchKey(True, lKeys(lIdx))
        If grSelection.SelectedLine(0, "STATIC") <> 1 Then
            grSelection.DeleteLine (lKeys(lIdx))
        End If
    Next
    grSelection.DeselectRow
    
    
    grSelection.Visible = True
    If lStaticSelect Then
        Call SendMessage(980, "#You cannot delete the existing items from here", mLanguage_Code)
    End If
    
    Screen.MousePointer = lScreenPointer
End Sub


Private Function FindInFullResult(ByVal AKey As Variant) As Boolean

    Dim lIdx As Long, lCount As Long
    
    If Not IsArray(mFullResult) Then Exit Function
    
    lCount = UBound(mFullResult, 1)
    For lIdx = 0 To lCount
        If StrComp(mFullResult(lIdx, 0), AKey(0), vbTextCompare) = 0 Then
            If StrComp(mFullResult(lIdx, 1), AKey(1), vbTextCompare) = 0 Then
                If StrComp(mFullResult(lIdx, 2), AKey(2), vbTextCompare) = 0 Then
                    FindInFullResult = True
                    Exit Function
                End If
            End If
        End If
    Next

End Function


Private Sub ClearSelection()
    
    grSelection.Visible = False
    grResult.Visible = False
    
    Dim lIdx As Long, lCount As Long, lCountCol As Long, lIdxCol As Long
    
    ReDim lLine(grResult.Cols - 1)
    lCount = grSelection.Row
    grSelection.FirstLine
    For lIdx = 0 To lCount
        If grSelection.SelectedLine(0, "STATIC") <> 1 Then
        If FindInFullResult(grSelection.SelectedKey(0)) Then
            lCountCol = grResult.Cols - 1
            For lIdxCol = 0 To lCountCol
                lLine(lIdxCol) = grSelection.SelectedLine(0, lIdxCol)
            Next
            grResult.AddLine (lLine)
        End If
            grSelection.DeleteLine
        End If
        grSelection.NextLine
    Next
    grSelection.DeselectRow
    grSelection.Visible = True
    grResult.Visible = True
    
End Sub

Private Sub txtRef_KeyUp(KeyCode As Integer, Shift As Integer)
    If KeyCode = 13 Then SearchDirectInput
End Sub

Private Function LoadResultGrid() As Boolean
    
    grResult.Visible = False

    ' Load the grid
    If Not grResult.Execute Then
        'debug.print "Error in loadresultgrid"
        Exit Function
    End If

    ' Load all items !
    Call grResult.LastLine
    Call grResult.FirstLine

    If grResult.Rows = 0 Then
        mFullResult = 0
        LoadResultGrid = True
        Exit Function
    End If

    Dim lIdx As Long, lCount As Long
    lCount = grResult.Rows - 1

    ' Create the selection !
    ' TODO : check what's happend if the grid is empty
    ReDim mFullResult(lCount, 2)
    For lIdx = 0 To lCount
        mFullResult(lIdx, 0) = grResult.Data(lIdx, 0)
        mFullResult(lIdx, 1) = grResult.Data(lIdx, 1)
        mFullResult(lIdx, 2) = grResult.Data(lIdx, 2)
    Next
    
    ' Filter the result grid by the selected grid
    lCount = grSelection.Rows - 1
    For lIdx = 0 To lCount
        Call grResult.DeleteLine(Array(grSelection.Data(lIdx, 0), grSelection.Data(lIdx, 1), grSelection.Data(lIdx, 2)))
    Next
    
    grResult.Visible = True
    
    LoadResultGrid = True

End Function


Public Sub AddStaticItem(ByVal aItem As Variant)
    ReDim Preserve aItem(15)
    aItem(15) = 1
    grSelection.AddLine (aItem)
    'grSelection.LineColor(grSelection.Rows - 1) = vbBlack
    grSelection.LineColor(grSelection.Rows - 1) = C_STATIC_COLOR
    grSelection.LastLine
    grSelection.FirstLine
End Sub




Private Sub SendSelection()

    If grSelection.Rows < 1 Then Exit Sub
    
    Dim lItems() As String
    Dim lRows() As Boolean
    Dim lRealIdx() As Long
    
    ReDim lItems(grSelection.Rows - 1)
    ReDim lRows(grSelection.Rows - 1)
    ReDim lRealIdx(grSelection.Rows - 1)
    
    Dim lIdx As Long, lCount As Long, lColIdx As Long, lColCount As Long, lItemIdx As Long
    lCount = UBound(lItems)
    lColCount = grSelection.Cols - 2
    lItemIdx = 0
    For lIdx = 0 To lCount
        If grSelection.Data(lIdx, 15) = "1" Then
            lRealIdx(lIdx) = -1
            GoTo NextOne
        End If
        lRealIdx(lIdx) = lItemIdx
        For lColIdx = 0 To lColCount
            lItems(lItemIdx) = lItems(lItemIdx) & grSelection.Data(lIdx, lColIdx) & CH_LDELIMIT
        Next
        lItems(lItemIdx) = Left(lItems(lItemIdx), Len(lItems(lItemIdx)) - Len(CH_LDELIMIT))
        lRows(lItemIdx) = False
        lItemIdx = lItemIdx + 1
NextOne:
    Next
    
    If lItemIdx = 0 Then
        RaiseEvent quit
        Exit Sub
    End If
    
    
    ReDim Preserve lItems(lItemIdx - 1)
    ReDim Preserve lRows(lItemIdx - 1)
    
    RaiseEvent SelectItems(lItems, lRows)
    Dim lError
    For lIdx = 0 To lCount
        If lRealIdx(lIdx) <> -1 Then
            If lRows(lRealIdx(lIdx)) Then
                grSelection.LineColor(lRealIdx(lIdx)) = C_STATIC_COLOR
            Else
                lError = True
            End If
        End If
    Next lIdx
    
    If Not lError Then
        RaiseEvent quit
    Else
        SendMessage 965, "Impossible to insert item(s) remaining in selected grid.", mLanguage_Code
    End If

End Sub

